package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudletsPolicyActivationPolicyInfoArgs private(
  activatedBy: Output[String],
  activationDate: Output[Int],
  name: Output[String],
  policyId: Output[Int],
  status: Output[String],
  statusDetail: Output[String],
  version: Output[Int]
) derives Encoder, ArgsEncoder

object GetCloudletsPolicyActivationPolicyInfoArgs:
  def apply(
    activatedBy: Input[String],
    activationDate: Input[Int],
    name: Input[String],
    policyId: Input[Int],
    status: Input[String],
    statusDetail: Input[String],
    version: Input[Int]
  )(using Context): GetCloudletsPolicyActivationPolicyInfoArgs =
    new GetCloudletsPolicyActivationPolicyInfoArgs(
      activatedBy = activatedBy.asOutput(isSecret = false),
      activationDate = activationDate.asOutput(isSecret = false),
      name = name.asOutput(isSecret = false),
      policyId = policyId.asOutput(isSecret = false),
      status = status.asOutput(isSecret = false),
      statusDetail = statusDetail.asOutput(isSecret = false),
      version = version.asOutput(isSecret = false)
    )
