package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudletsPolicyActivationPropertyInfoArgs private(
  activatedBy: Output[String],
  activationDate: Output[Int],
  groupId: Output[Int],
  name: Output[String],
  status: Output[String],
  version: Output[Int]
) derives Encoder, ArgsEncoder

object GetCloudletsPolicyActivationPropertyInfoArgs:
  def apply(
    activatedBy: Input[String],
    activationDate: Input[Int],
    groupId: Input[Int],
    name: Input[String],
    status: Input[String],
    version: Input[Int]
  )(using Context): GetCloudletsPolicyActivationPropertyInfoArgs =
    new GetCloudletsPolicyActivationPropertyInfoArgs(
      activatedBy = activatedBy.asOutput(isSecret = false),
      activationDate = activationDate.asOutput(isSecret = false),
      groupId = groupId.asOutput(isSecret = false),
      name = name.asOutput(isSecret = false),
      status = status.asOutput(isSecret = false),
      version = version.asOutput(isSecret = false)
    )
