package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudletsRequestControlMatchRuleMatchRuleArgs private(
  allowDeny: Output[String],
  disabled: Output[Option[Boolean]],
  end: Output[Option[Int]],
  matches: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GetCloudletsRequestControlMatchRuleMatchRuleMatchArgs]]],
  matchesAlways: Output[Option[Boolean]],
  name: Output[Option[String]],
  start: Output[Option[Int]],
  `type`: Output[String]
) derives Encoder, ArgsEncoder

object GetCloudletsRequestControlMatchRuleMatchRuleArgs:
  def apply(
    allowDeny: Input[String],
    disabled: Input.Optional[Boolean] = None,
    end: Input.Optional[Int] = None,
    matches: Input.Optional[List[Input[besom.api.akamai.inputs.GetCloudletsRequestControlMatchRuleMatchRuleMatchArgs]]] = None,
    matchesAlways: Input.Optional[Boolean] = None,
    name: Input.Optional[String] = None,
    start: Input.Optional[Int] = None,
    `type`: Input[String]
  )(using Context): GetCloudletsRequestControlMatchRuleMatchRuleArgs =
    new GetCloudletsRequestControlMatchRuleMatchRuleArgs(
      allowDeny = allowDeny.asOutput(isSecret = false),
      disabled = disabled.asOptionOutput(isSecret = false),
      end = end.asOptionOutput(isSecret = false),
      matches = matches.asOptionOutput(isSecret = false),
      matchesAlways = matchesAlways.asOptionOutput(isSecret = false),
      name = name.asOptionOutput(isSecret = false),
      start = start.asOptionOutput(isSecret = false),
      `type` = `type`.asOutput(isSecret = false)
    )
