package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudwrapperCapacitiesCapacityArgs private(
  approved: Output[besom.api.akamai.inputs.GetCloudwrapperCapacitiesCapacityApprovedArgs],
  assigned: Output[besom.api.akamai.inputs.GetCloudwrapperCapacitiesCapacityAssignedArgs],
  contractId: Output[String],
  locationId: Output[Int],
  locationName: Output[String],
  `type`: Output[String],
  unassigned: Output[besom.api.akamai.inputs.GetCloudwrapperCapacitiesCapacityUnassignedArgs]
) derives Encoder, ArgsEncoder

object GetCloudwrapperCapacitiesCapacityArgs:
  def apply(
    approved: Input[besom.api.akamai.inputs.GetCloudwrapperCapacitiesCapacityApprovedArgs],
    assigned: Input[besom.api.akamai.inputs.GetCloudwrapperCapacitiesCapacityAssignedArgs],
    contractId: Input[String],
    locationId: Input[Int],
    locationName: Input[String],
    `type`: Input[String],
    unassigned: Input[besom.api.akamai.inputs.GetCloudwrapperCapacitiesCapacityUnassignedArgs]
  )(using Context): GetCloudwrapperCapacitiesCapacityArgs =
    new GetCloudwrapperCapacitiesCapacityArgs(
      approved = approved.asOutput(isSecret = false),
      assigned = assigned.asOutput(isSecret = false),
      contractId = contractId.asOutput(isSecret = false),
      locationId = locationId.asOutput(isSecret = false),
      locationName = locationName.asOutput(isSecret = false),
      `type` = `type`.asOutput(isSecret = false),
      unassigned = unassigned.asOutput(isSecret = false)
    )
