package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudwrapperConfigurationLocationArgs private(
  capacity: Output[besom.api.akamai.inputs.GetCloudwrapperConfigurationLocationCapacityArgs],
  comments: Output[String],
  mapName: Output[String],
  trafficTypeId: Output[Int]
) derives Encoder, ArgsEncoder

object GetCloudwrapperConfigurationLocationArgs:
  def apply(
    capacity: Input[besom.api.akamai.inputs.GetCloudwrapperConfigurationLocationCapacityArgs],
    comments: Input[String],
    mapName: Input[String],
    trafficTypeId: Input[Int]
  )(using Context): GetCloudwrapperConfigurationLocationArgs =
    new GetCloudwrapperConfigurationLocationArgs(
      capacity = capacity.asOutput(isSecret = false),
      comments = comments.asOutput(isSecret = false),
      mapName = mapName.asOutput(isSecret = false),
      trafficTypeId = trafficTypeId.asOutput(isSecret = false)
    )
