package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudwrapperConfigurationMultiCdnSettingsCdnCdnAuthKeyArgs private(
  authKeyName: Output[String],
  expiryDate: Output[String],
  headerName: Output[String],
  secret: Output[String]
) derives Encoder, ArgsEncoder

object GetCloudwrapperConfigurationMultiCdnSettingsCdnCdnAuthKeyArgs:
  def apply(
    authKeyName: Input[String],
    expiryDate: Input[String],
    headerName: Input[String],
    secret: Input[String]
  )(using Context): GetCloudwrapperConfigurationMultiCdnSettingsCdnCdnAuthKeyArgs =
    new GetCloudwrapperConfigurationMultiCdnSettingsCdnCdnAuthKeyArgs(
      authKeyName = authKeyName.asOutput(isSecret = false),
      expiryDate = expiryDate.asOutput(isSecret = false),
      headerName = headerName.asOutput(isSecret = false),
      secret = secret.asOutput(isSecret = false)
    )
