package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudwrapperConfigurationsConfigurationArgs private(
  capacityAlertsThreshold: Output[Int],
  comments: Output[String],
  configName: Output[String],
  contractId: Output[String],
  id: Output[Int],
  lastActivatedBy: Output[String],
  lastActivatedDate: Output[String],
  lastUpdatedBy: Output[String],
  lastUpdatedDate: Output[String],
  locations: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GetCloudwrapperConfigurationsConfigurationLocationArgs]]],
  multiCdnSettings: Output[Option[besom.api.akamai.inputs.GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsArgs]],
  notificationEmails: Output[scala.collection.immutable.List[String]],
  propertyIds: Output[scala.collection.immutable.List[String]],
  retainIdleObjects: Output[Boolean],
  status: Output[String]
) derives Encoder, ArgsEncoder

object GetCloudwrapperConfigurationsConfigurationArgs:
  def apply(
    capacityAlertsThreshold: Input[Int],
    comments: Input[String],
    configName: Input[String],
    contractId: Input[String],
    id: Input[Int],
    lastActivatedBy: Input[String],
    lastActivatedDate: Input[String],
    lastUpdatedBy: Input[String],
    lastUpdatedDate: Input[String],
    locations: Input.Optional[List[Input[besom.api.akamai.inputs.GetCloudwrapperConfigurationsConfigurationLocationArgs]]] = None,
    multiCdnSettings: Input.Optional[besom.api.akamai.inputs.GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsArgs] = None,
    notificationEmails: Input[List[Input[String]]],
    propertyIds: Input[List[Input[String]]],
    retainIdleObjects: Input[Boolean],
    status: Input[String]
  )(using Context): GetCloudwrapperConfigurationsConfigurationArgs =
    new GetCloudwrapperConfigurationsConfigurationArgs(
      capacityAlertsThreshold = capacityAlertsThreshold.asOutput(isSecret = false),
      comments = comments.asOutput(isSecret = false),
      configName = configName.asOutput(isSecret = false),
      contractId = contractId.asOutput(isSecret = false),
      id = id.asOutput(isSecret = false),
      lastActivatedBy = lastActivatedBy.asOutput(isSecret = false),
      lastActivatedDate = lastActivatedDate.asOutput(isSecret = false),
      lastUpdatedBy = lastUpdatedBy.asOutput(isSecret = false),
      lastUpdatedDate = lastUpdatedDate.asOutput(isSecret = false),
      locations = locations.asOptionOutput(isSecret = false),
      multiCdnSettings = multiCdnSettings.asOptionOutput(isSecret = false),
      notificationEmails = notificationEmails.asOutput(isSecret = false),
      propertyIds = propertyIds.asOutput(isSecret = false),
      retainIdleObjects = retainIdleObjects.asOutput(isSecret = false),
      status = status.asOutput(isSecret = false)
    )
