package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudwrapperConfigurationsConfigurationLocationArgs private(
  capacity: Output[besom.api.akamai.inputs.GetCloudwrapperConfigurationsConfigurationLocationCapacityArgs],
  comments: Output[String],
  mapName: Output[String],
  trafficTypeId: Output[Int]
) derives Encoder, ArgsEncoder

object GetCloudwrapperConfigurationsConfigurationLocationArgs:
  def apply(
    capacity: Input[besom.api.akamai.inputs.GetCloudwrapperConfigurationsConfigurationLocationCapacityArgs],
    comments: Input[String],
    mapName: Input[String],
    trafficTypeId: Input[Int]
  )(using Context): GetCloudwrapperConfigurationsConfigurationLocationArgs =
    new GetCloudwrapperConfigurationsConfigurationLocationArgs(
      capacity = capacity.asOutput(isSecret = false),
      comments = comments.asOutput(isSecret = false),
      mapName = mapName.asOutput(isSecret = false),
      trafficTypeId = trafficTypeId.asOutput(isSecret = false)
    )
