package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsBoccArgs private(
  conditionalSamplingFrequency: Output[String],
  enabled: Output[Boolean],
  forwardType: Output[String],
  requestType: Output[String],
  samplingFrequency: Output[String]
) derives Encoder, ArgsEncoder

object GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsBoccArgs:
  def apply(
    conditionalSamplingFrequency: Input[String],
    enabled: Input[Boolean],
    forwardType: Input[String],
    requestType: Input[String],
    samplingFrequency: Input[String]
  )(using Context): GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsBoccArgs =
    new GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsBoccArgs(
      conditionalSamplingFrequency = conditionalSamplingFrequency.asOutput(isSecret = false),
      enabled = enabled.asOutput(isSecret = false),
      forwardType = forwardType.asOutput(isSecret = false),
      requestType = requestType.asOutput(isSecret = false),
      samplingFrequency = samplingFrequency.asOutput(isSecret = false)
    )
