package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsCdnArgs private(
  cdnAuthKeys: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsCdnCdnAuthKeyArgs]]],
  cdnCode: Output[String],
  enabled: Output[Boolean],
  httpsOnly: Output[Boolean],
  ipAclCidrs: Output[scala.collection.immutable.List[String]]
) derives Encoder, ArgsEncoder

object GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsCdnArgs:
  def apply(
    cdnAuthKeys: Input.Optional[List[Input[besom.api.akamai.inputs.GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsCdnCdnAuthKeyArgs]]] = None,
    cdnCode: Input[String],
    enabled: Input[Boolean],
    httpsOnly: Input[Boolean],
    ipAclCidrs: Input[List[Input[String]]]
  )(using Context): GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsCdnArgs =
    new GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsCdnArgs(
      cdnAuthKeys = cdnAuthKeys.asOptionOutput(isSecret = false),
      cdnCode = cdnCode.asOutput(isSecret = false),
      enabled = enabled.asOutput(isSecret = false),
      httpsOnly = httpsOnly.asOutput(isSecret = false),
      ipAclCidrs = ipAclCidrs.asOutput(isSecret = false)
    )
