package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsDataStreamsArgs private(
  dataStreamIds: Output[scala.collection.immutable.List[Int]],
  enabled: Output[Boolean],
  samplingRate: Output[Int]
) derives Encoder, ArgsEncoder

object GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsDataStreamsArgs:
  def apply(
    dataStreamIds: Input[List[Input[Int]]],
    enabled: Input[Boolean],
    samplingRate: Input[Int]
  )(using Context): GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsDataStreamsArgs =
    new GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsDataStreamsArgs(
      dataStreamIds = dataStreamIds.asOutput(isSecret = false),
      enabled = enabled.asOutput(isSecret = false),
      samplingRate = samplingRate.asOutput(isSecret = false)
    )
