package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsOriginArgs private(
  hostname: Output[String],
  originId: Output[String],
  propertyId: Output[Int]
) derives Encoder, ArgsEncoder

object GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsOriginArgs:
  def apply(
    hostname: Input[String],
    originId: Input[String],
    propertyId: Input[Int]
  )(using Context): GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsOriginArgs =
    new GetCloudwrapperConfigurationsConfigurationMultiCdnSettingsOriginArgs(
      hostname = hostname.asOutput(isSecret = false),
      originId = originId.asOutput(isSecret = false),
      propertyId = propertyId.asOutput(isSecret = false)
    )
