package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudwrapperLocationsLocationArgs private(
  locationId: Output[Int],
  locationName: Output[String],
  multiCdnLocationId: Output[String],
  trafficTypes: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GetCloudwrapperLocationsLocationTrafficTypeArgs]]]
) derives Encoder, ArgsEncoder

object GetCloudwrapperLocationsLocationArgs:
  def apply(
    locationId: Input[Int],
    locationName: Input[String],
    multiCdnLocationId: Input[String],
    trafficTypes: Input.Optional[List[Input[besom.api.akamai.inputs.GetCloudwrapperLocationsLocationTrafficTypeArgs]]] = None
  )(using Context): GetCloudwrapperLocationsLocationArgs =
    new GetCloudwrapperLocationsLocationArgs(
      locationId = locationId.asOutput(isSecret = false),
      locationName = locationName.asOutput(isSecret = false),
      multiCdnLocationId = multiCdnLocationId.asOutput(isSecret = false),
      trafficTypes = trafficTypes.asOptionOutput(isSecret = false)
    )
