package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudwrapperLocationsLocationTrafficTypeArgs private(
  locationId: Output[String],
  trafficType: Output[String],
  trafficTypeId: Output[Int]
) derives Encoder, ArgsEncoder

object GetCloudwrapperLocationsLocationTrafficTypeArgs:
  def apply(
    locationId: Input[String],
    trafficType: Input[String],
    trafficTypeId: Input[Int]
  )(using Context): GetCloudwrapperLocationsLocationTrafficTypeArgs =
    new GetCloudwrapperLocationsLocationTrafficTypeArgs(
      locationId = locationId.asOutput(isSecret = false),
      trafficType = trafficType.asOutput(isSecret = false),
      trafficTypeId = trafficTypeId.asOutput(isSecret = false)
    )
