package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetCloudwrapperPropertiesPropertyArgs private(
  contractId: Output[String],
  groupId: Output[Int],
  propertyId: Output[Int],
  propertyName: Output[String],
  `type`: Output[String]
) derives Encoder, ArgsEncoder

object GetCloudwrapperPropertiesPropertyArgs:
  def apply(
    contractId: Input[String],
    groupId: Input[Int],
    propertyId: Input[Int],
    propertyName: Input[String],
    `type`: Input[String]
  )(using Context): GetCloudwrapperPropertiesPropertyArgs =
    new GetCloudwrapperPropertiesPropertyArgs(
      contractId = contractId.asOutput(isSecret = false),
      groupId = groupId.asOutput(isSecret = false),
      propertyId = propertyId.asOutput(isSecret = false),
      propertyName = propertyName.asOutput(isSecret = false),
      `type` = `type`.asOutput(isSecret = false)
    )
