package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetContractsContractArgs private(
  contractId: Output[String],
  contractTypeName: Output[String]
) derives Encoder, ArgsEncoder

object GetContractsContractArgs:
  def apply(
    contractId: Input[String],
    contractTypeName: Input[String]
  )(using Context): GetContractsContractArgs =
    new GetContractsContractArgs(
      contractId = contractId.asOutput(isSecret = false),
      contractTypeName = contractTypeName.asOutput(isSecret = false)
    )
