package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetDatastreamActivationHistoryActivationArgs private(
  modifiedBy: Output[String],
  modifiedDate: Output[String],
  status: Output[String],
  streamId: Output[Int],
  streamVersion: Output[Int]
) derives Encoder, ArgsEncoder

object GetDatastreamActivationHistoryActivationArgs:
  def apply(
    modifiedBy: Input[String],
    modifiedDate: Input[String],
    status: Input[String],
    streamId: Input[Int],
    streamVersion: Input[Int]
  )(using Context): GetDatastreamActivationHistoryActivationArgs =
    new GetDatastreamActivationHistoryActivationArgs(
      modifiedBy = modifiedBy.asOutput(isSecret = false),
      modifiedDate = modifiedDate.asOutput(isSecret = false),
      status = status.asOutput(isSecret = false),
      streamId = streamId.asOutput(isSecret = false),
      streamVersion = streamVersion.asOutput(isSecret = false)
    )
