package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetDatastreamDatasetFieldsDatasetFieldArgs private(
  datasetFieldDescription: Output[String],
  datasetFieldGroup: Output[String],
  datasetFieldId: Output[Int],
  datasetFieldJsonKey: Output[String],
  datasetFieldName: Output[String]
) derives Encoder, ArgsEncoder

object GetDatastreamDatasetFieldsDatasetFieldArgs:
  def apply(
    datasetFieldDescription: Input[String],
    datasetFieldGroup: Input[String],
    datasetFieldId: Input[Int],
    datasetFieldJsonKey: Input[String],
    datasetFieldName: Input[String]
  )(using Context): GetDatastreamDatasetFieldsDatasetFieldArgs =
    new GetDatastreamDatasetFieldsDatasetFieldArgs(
      datasetFieldDescription = datasetFieldDescription.asOutput(isSecret = false),
      datasetFieldGroup = datasetFieldGroup.asOutput(isSecret = false),
      datasetFieldId = datasetFieldId.asOutput(isSecret = false),
      datasetFieldJsonKey = datasetFieldJsonKey.asOutput(isSecret = false),
      datasetFieldName = datasetFieldName.asOutput(isSecret = false)
    )
