package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetDatastreamsStreamsDetailArgs private(
  contractId: Output[String],
  createdBy: Output[String],
  createdDate: Output[String],
  groupId: Output[Int],
  latestVersion: Output[Int],
  modifiedBy: Output[String],
  modifiedDate: Output[String],
  productId: Output[String],
  properties: Output[scala.collection.immutable.List[besom.api.akamai.inputs.GetDatastreamsStreamsDetailPropertyArgs]],
  streamId: Output[Int],
  streamName: Output[String],
  streamStatus: Output[String],
  streamVersion: Output[Int]
) derives Encoder, ArgsEncoder

object GetDatastreamsStreamsDetailArgs:
  def apply(
    contractId: Input[String],
    createdBy: Input[String],
    createdDate: Input[String],
    groupId: Input[Int],
    latestVersion: Input[Int],
    modifiedBy: Input[String],
    modifiedDate: Input[String],
    productId: Input[String],
    properties: Input[List[Input[besom.api.akamai.inputs.GetDatastreamsStreamsDetailPropertyArgs]]],
    streamId: Input[Int],
    streamName: Input[String],
    streamStatus: Input[String],
    streamVersion: Input[Int]
  )(using Context): GetDatastreamsStreamsDetailArgs =
    new GetDatastreamsStreamsDetailArgs(
      contractId = contractId.asOutput(isSecret = false),
      createdBy = createdBy.asOutput(isSecret = false),
      createdDate = createdDate.asOutput(isSecret = false),
      groupId = groupId.asOutput(isSecret = false),
      latestVersion = latestVersion.asOutput(isSecret = false),
      modifiedBy = modifiedBy.asOutput(isSecret = false),
      modifiedDate = modifiedDate.asOutput(isSecret = false),
      productId = productId.asOutput(isSecret = false),
      properties = properties.asOutput(isSecret = false),
      streamId = streamId.asOutput(isSecret = false),
      streamName = streamName.asOutput(isSecret = false),
      streamStatus = streamStatus.asOutput(isSecret = false),
      streamVersion = streamVersion.asOutput(isSecret = false)
    )
