package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetDatastreamsStreamsDetailPropertyArgs private(
  propertyId: Output[Int],
  propertyName: Output[String]
) derives Encoder, ArgsEncoder

object GetDatastreamsStreamsDetailPropertyArgs:
  def apply(
    propertyId: Input[Int],
    propertyName: Input[String]
  )(using Context): GetDatastreamsStreamsDetailPropertyArgs =
    new GetDatastreamsStreamsDetailPropertyArgs(
      propertyId = propertyId.asOutput(isSecret = false),
      propertyName = propertyName.asOutput(isSecret = false)
    )
