package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetGroupsGroupArgs private(
  contractIds: Output[scala.collection.immutable.List[String]],
  groupId: Output[String],
  groupName: Output[String],
  parentGroupId: Output[String]
) derives Encoder, ArgsEncoder

object GetGroupsGroupArgs:
  def apply(
    contractIds: Input[List[Input[String]]],
    groupId: Input[String],
    groupName: Input[String],
    parentGroupId: Input[String]
  )(using Context): GetGroupsGroupArgs =
    new GetGroupsGroupArgs(
      contractIds = contractIds.asOutput(isSecret = false),
      groupId = groupId.asOutput(isSecret = false),
      groupName = groupName.asOutput(isSecret = false),
      parentGroupId = parentGroupId.asOutput(isSecret = false)
    )
