package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetGtmDatacenterDefaultLoadObjectArgs private(
  loadObject: Output[String],
  loadObjectPort: Output[Int],
  loadServers: Output[scala.collection.immutable.List[String]]
) derives Encoder, ArgsEncoder

object GetGtmDatacenterDefaultLoadObjectArgs:
  def apply(
    loadObject: Input[String],
    loadObjectPort: Input[Int],
    loadServers: Input[List[Input[String]]]
  )(using Context): GetGtmDatacenterDefaultLoadObjectArgs =
    new GetGtmDatacenterDefaultLoadObjectArgs(
      loadObject = loadObject.asOutput(isSecret = false),
      loadObjectPort = loadObjectPort.asOutput(isSecret = false),
      loadServers = loadServers.asOutput(isSecret = false)
    )
