package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetGtmDatacenterLinkArgs private(
  href: Output[String],
  rel: Output[String]
) derives Encoder, ArgsEncoder

object GetGtmDatacenterLinkArgs:
  def apply(
    href: Input[String],
    rel: Input[String]
  )(using Context): GetGtmDatacenterLinkArgs =
    new GetGtmDatacenterLinkArgs(
      href = href.asOutput(isSecret = false),
      rel = rel.asOutput(isSecret = false)
    )
