package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetGtmDatacentersDatacenterArgs private(
  city: Output[String],
  cloneOf: Output[Int],
  cloudServerHostHeaderOverride: Output[Boolean],
  cloudServerTargeting: Output[Boolean],
  continent: Output[String],
  country: Output[String],
  datacenterId: Output[Int],
  defaultLoadObjects: Output[scala.collection.immutable.List[besom.api.akamai.inputs.GetGtmDatacentersDatacenterDefaultLoadObjectArgs]],
  latitude: Output[Double],
  links: Output[scala.collection.immutable.List[besom.api.akamai.inputs.GetGtmDatacentersDatacenterLinkArgs]],
  longitude: Output[Double],
  nickname: Output[String],
  scorePenalty: Output[Int],
  servermonitorPool: Output[String],
  stateOrProvince: Output[String],
  virtual: Output[Boolean]
) derives Encoder, ArgsEncoder

object GetGtmDatacentersDatacenterArgs:
  def apply(
    city: Input[String],
    cloneOf: Input[Int],
    cloudServerHostHeaderOverride: Input[Boolean],
    cloudServerTargeting: Input[Boolean],
    continent: Input[String],
    country: Input[String],
    datacenterId: Input[Int],
    defaultLoadObjects: Input[List[Input[besom.api.akamai.inputs.GetGtmDatacentersDatacenterDefaultLoadObjectArgs]]],
    latitude: Input[Double],
    links: Input[List[Input[besom.api.akamai.inputs.GetGtmDatacentersDatacenterLinkArgs]]],
    longitude: Input[Double],
    nickname: Input[String],
    scorePenalty: Input[Int],
    servermonitorPool: Input[String],
    stateOrProvince: Input[String],
    virtual: Input[Boolean]
  )(using Context): GetGtmDatacentersDatacenterArgs =
    new GetGtmDatacentersDatacenterArgs(
      city = city.asOutput(isSecret = false),
      cloneOf = cloneOf.asOutput(isSecret = false),
      cloudServerHostHeaderOverride = cloudServerHostHeaderOverride.asOutput(isSecret = false),
      cloudServerTargeting = cloudServerTargeting.asOutput(isSecret = false),
      continent = continent.asOutput(isSecret = false),
      country = country.asOutput(isSecret = false),
      datacenterId = datacenterId.asOutput(isSecret = false),
      defaultLoadObjects = defaultLoadObjects.asOutput(isSecret = false),
      latitude = latitude.asOutput(isSecret = false),
      links = links.asOutput(isSecret = false),
      longitude = longitude.asOutput(isSecret = false),
      nickname = nickname.asOutput(isSecret = false),
      scorePenalty = scorePenalty.asOutput(isSecret = false),
      servermonitorPool = servermonitorPool.asOutput(isSecret = false),
      stateOrProvince = stateOrProvince.asOutput(isSecret = false),
      virtual = virtual.asOutput(isSecret = false)
    )
