package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetIamGrantableRolesGrantableRoleArgs private(
  description: Output[String],
  grantedRoleId: Output[Int],
  name: Output[String]
) derives Encoder, ArgsEncoder

object GetIamGrantableRolesGrantableRoleArgs:
  def apply(
    description: Input[String],
    grantedRoleId: Input[Int],
    name: Input[String]
  )(using Context): GetIamGrantableRolesGrantableRoleArgs =
    new GetIamGrantableRolesGrantableRoleArgs(
      description = description.asOutput(isSecret = false),
      grantedRoleId = grantedRoleId.asOutput(isSecret = false),
      name = name.asOutput(isSecret = false)
    )
