package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetIamRolesRoleArgs private(
  createdBy: Output[String],
  description: Output[String],
  modifiedBy: Output[String],
  name: Output[String],
  roleId: Output[String],
  timeCreated: Output[String],
  timeModified: Output[String],
  `type`: Output[String]
) derives Encoder, ArgsEncoder

object GetIamRolesRoleArgs:
  def apply(
    createdBy: Input[String],
    description: Input[String],
    modifiedBy: Input[String],
    name: Input[String],
    roleId: Input[String],
    timeCreated: Input[String],
    timeModified: Input[String],
    `type`: Input[String]
  )(using Context): GetIamRolesRoleArgs =
    new GetIamRolesRoleArgs(
      createdBy = createdBy.asOutput(isSecret = false),
      description = description.asOutput(isSecret = false),
      modifiedBy = modifiedBy.asOutput(isSecret = false),
      name = name.asOutput(isSecret = false),
      roleId = roleId.asOutput(isSecret = false),
      timeCreated = timeCreated.asOutput(isSecret = false),
      timeModified = timeModified.asOutput(isSecret = false),
      `type` = `type`.asOutput(isSecret = false)
    )
