package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetIamTimezonesTimezoneArgs private(
  description: Output[String],
  offset: Output[String],
  posix: Output[String],
  timezone: Output[String]
) derives Encoder, ArgsEncoder

object GetIamTimezonesTimezoneArgs:
  def apply(
    description: Input[String],
    offset: Input[String],
    posix: Input[String],
    timezone: Input[String]
  )(using Context): GetIamTimezonesTimezoneArgs =
    new GetIamTimezonesTimezoneArgs(
      description = description.asOutput(isSecret = false),
      offset = offset.asOutput(isSecret = false),
      posix = posix.asOutput(isSecret = false),
      timezone = timezone.asOutput(isSecret = false)
    )
