package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyArgs private(
  breakpoints: Output[Option[besom.api.akamai.inputs.GetImagingPolicyImagePolicyBreakpointsArgs]],
  hosts: Output[Option[scala.collection.immutable.List[String]]],
  output: Output[Option[besom.api.akamai.inputs.GetImagingPolicyImagePolicyOutputArgs]],
  postBreakpointTransformations: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GetImagingPolicyImagePolicyPostBreakpointTransformationArgs]]],
  rolloutDuration: Output[Option[String]],
  transformations: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GetImagingPolicyImagePolicyTransformationArgs]]],
  variables: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GetImagingPolicyImagePolicyVariableArgs]]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyArgs:
  def apply(
    breakpoints: Input.Optional[besom.api.akamai.inputs.GetImagingPolicyImagePolicyBreakpointsArgs] = None,
    hosts: Input.Optional[List[Input[String]]] = None,
    output: Input.Optional[besom.api.akamai.inputs.GetImagingPolicyImagePolicyOutputArgs] = None,
    postBreakpointTransformations: Input.Optional[List[Input[besom.api.akamai.inputs.GetImagingPolicyImagePolicyPostBreakpointTransformationArgs]]] = None,
    rolloutDuration: Input.Optional[String] = None,
    transformations: Input.Optional[List[Input[besom.api.akamai.inputs.GetImagingPolicyImagePolicyTransformationArgs]]] = None,
    variables: Input.Optional[List[Input[besom.api.akamai.inputs.GetImagingPolicyImagePolicyVariableArgs]]] = None
  )(using Context): GetImagingPolicyImagePolicyArgs =
    new GetImagingPolicyImagePolicyArgs(
      breakpoints = breakpoints.asOptionOutput(isSecret = false),
      hosts = hosts.asOptionOutput(isSecret = false),
      output = output.asOptionOutput(isSecret = false),
      postBreakpointTransformations = postBreakpointTransformations.asOptionOutput(isSecret = false),
      rolloutDuration = rolloutDuration.asOptionOutput(isSecret = false),
      transformations = transformations.asOptionOutput(isSecret = false),
      variables = variables.asOptionOutput(isSecret = false)
    )
