package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyOutputArgs private(
  adaptiveQuality: Output[Option[String]],
  allowedFormats: Output[Option[scala.collection.immutable.List[String]]],
  forcedFormats: Output[Option[scala.collection.immutable.List[String]]],
  perceptualQuality: Output[Option[String]],
  perceptualQualityFloor: Output[Option[String]],
  perceptualQualityVar: Output[Option[String]],
  quality: Output[Option[String]],
  qualityVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyOutputArgs:
  def apply(
    adaptiveQuality: Input.Optional[String] = None,
    allowedFormats: Input.Optional[List[Input[String]]] = None,
    forcedFormats: Input.Optional[List[Input[String]]] = None,
    perceptualQuality: Input.Optional[String] = None,
    perceptualQualityFloor: Input.Optional[String] = None,
    perceptualQualityVar: Input.Optional[String] = None,
    quality: Input.Optional[String] = None,
    qualityVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyOutputArgs =
    new GetImagingPolicyImagePolicyOutputArgs(
      adaptiveQuality = adaptiveQuality.asOptionOutput(isSecret = false),
      allowedFormats = allowedFormats.asOptionOutput(isSecret = false),
      forcedFormats = forcedFormats.asOptionOutput(isSecret = false),
      perceptualQuality = perceptualQuality.asOptionOutput(isSecret = false),
      perceptualQualityFloor = perceptualQualityFloor.asOptionOutput(isSecret = false),
      perceptualQualityVar = perceptualQualityVar.asOptionOutput(isSecret = false),
      quality = quality.asOptionOutput(isSecret = false),
      qualityVar = qualityVar.asOptionOutput(isSecret = false)
    )
