package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyPostBreakpointTransformationCompositeArgs private(
  gravity: Output[Option[String]],
  gravityVar: Output[Option[String]],
  image: Output[besom.api.akamai.inputs.GetImagingPolicyImagePolicyPostBreakpointTransformationCompositeImageArgs],
  placement: Output[Option[String]],
  placementVar: Output[Option[String]],
  scale: Output[Option[String]],
  scaleDimension: Output[Option[String]],
  scaleDimensionVar: Output[Option[String]],
  scaleVar: Output[Option[String]],
  xPosition: Output[Option[String]],
  xPositionVar: Output[Option[String]],
  yPosition: Output[Option[String]],
  yPositionVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyPostBreakpointTransformationCompositeArgs:
  def apply(
    gravity: Input.Optional[String] = None,
    gravityVar: Input.Optional[String] = None,
    image: Input[besom.api.akamai.inputs.GetImagingPolicyImagePolicyPostBreakpointTransformationCompositeImageArgs],
    placement: Input.Optional[String] = None,
    placementVar: Input.Optional[String] = None,
    scale: Input.Optional[String] = None,
    scaleDimension: Input.Optional[String] = None,
    scaleDimensionVar: Input.Optional[String] = None,
    scaleVar: Input.Optional[String] = None,
    xPosition: Input.Optional[String] = None,
    xPositionVar: Input.Optional[String] = None,
    yPosition: Input.Optional[String] = None,
    yPositionVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyPostBreakpointTransformationCompositeArgs =
    new GetImagingPolicyImagePolicyPostBreakpointTransformationCompositeArgs(
      gravity = gravity.asOptionOutput(isSecret = false),
      gravityVar = gravityVar.asOptionOutput(isSecret = false),
      image = image.asOutput(isSecret = false),
      placement = placement.asOptionOutput(isSecret = false),
      placementVar = placementVar.asOptionOutput(isSecret = false),
      scale = scale.asOptionOutput(isSecret = false),
      scaleDimension = scaleDimension.asOptionOutput(isSecret = false),
      scaleDimensionVar = scaleDimensionVar.asOptionOutput(isSecret = false),
      scaleVar = scaleVar.asOptionOutput(isSecret = false),
      xPosition = xPosition.asOptionOutput(isSecret = false),
      xPositionVar = xPositionVar.asOptionOutput(isSecret = false),
      yPosition = yPosition.asOptionOutput(isSecret = false),
      yPositionVar = yPositionVar.asOptionOutput(isSecret = false)
    )
