package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyPostBreakpointTransformationRemoveColorArgs private(
  color: Output[Option[String]],
  colorVar: Output[Option[String]],
  feather: Output[Option[String]],
  featherVar: Output[Option[String]],
  tolerance: Output[Option[String]],
  toleranceVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyPostBreakpointTransformationRemoveColorArgs:
  def apply(
    color: Input.Optional[String] = None,
    colorVar: Input.Optional[String] = None,
    feather: Input.Optional[String] = None,
    featherVar: Input.Optional[String] = None,
    tolerance: Input.Optional[String] = None,
    toleranceVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyPostBreakpointTransformationRemoveColorArgs =
    new GetImagingPolicyImagePolicyPostBreakpointTransformationRemoveColorArgs(
      color = color.asOptionOutput(isSecret = false),
      colorVar = colorVar.asOptionOutput(isSecret = false),
      feather = feather.asOptionOutput(isSecret = false),
      featherVar = featherVar.asOptionOutput(isSecret = false),
      tolerance = tolerance.asOptionOutput(isSecret = false),
      toleranceVar = toleranceVar.asOptionOutput(isSecret = false)
    )
