package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyTransformationAppendArgs private(
  gravity: Output[Option[String]],
  gravityPriority: Output[Option[String]],
  gravityPriorityVar: Output[Option[String]],
  gravityVar: Output[Option[String]],
  image: Output[besom.api.akamai.inputs.GetImagingPolicyImagePolicyTransformationAppendImageArgs],
  preserveMinorDimension: Output[Option[String]],
  preserveMinorDimensionVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyTransformationAppendArgs:
  def apply(
    gravity: Input.Optional[String] = None,
    gravityPriority: Input.Optional[String] = None,
    gravityPriorityVar: Input.Optional[String] = None,
    gravityVar: Input.Optional[String] = None,
    image: Input[besom.api.akamai.inputs.GetImagingPolicyImagePolicyTransformationAppendImageArgs],
    preserveMinorDimension: Input.Optional[String] = None,
    preserveMinorDimensionVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyTransformationAppendArgs =
    new GetImagingPolicyImagePolicyTransformationAppendArgs(
      gravity = gravity.asOptionOutput(isSecret = false),
      gravityPriority = gravityPriority.asOptionOutput(isSecret = false),
      gravityPriorityVar = gravityPriorityVar.asOptionOutput(isSecret = false),
      gravityVar = gravityVar.asOptionOutput(isSecret = false),
      image = image.asOutput(isSecret = false),
      preserveMinorDimension = preserveMinorDimension.asOptionOutput(isSecret = false),
      preserveMinorDimensionVar = preserveMinorDimensionVar.asOptionOutput(isSecret = false)
    )
