package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyTransformationBackgroundColorArgs private(
  color: Output[Option[String]],
  colorVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyTransformationBackgroundColorArgs:
  def apply(
    color: Input.Optional[String] = None,
    colorVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyTransformationBackgroundColorArgs =
    new GetImagingPolicyImagePolicyTransformationBackgroundColorArgs(
      color = color.asOptionOutput(isSecret = false),
      colorVar = colorVar.asOptionOutput(isSecret = false)
    )
