package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyTransformationChromaKeyArgs private(
  hue: Output[Option[String]],
  hueFeather: Output[Option[String]],
  hueFeatherVar: Output[Option[String]],
  hueTolerance: Output[Option[String]],
  hueToleranceVar: Output[Option[String]],
  hueVar: Output[Option[String]],
  lightnessFeather: Output[Option[String]],
  lightnessFeatherVar: Output[Option[String]],
  lightnessTolerance: Output[Option[String]],
  lightnessToleranceVar: Output[Option[String]],
  saturationFeather: Output[Option[String]],
  saturationFeatherVar: Output[Option[String]],
  saturationTolerance: Output[Option[String]],
  saturationToleranceVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyTransformationChromaKeyArgs:
  def apply(
    hue: Input.Optional[String] = None,
    hueFeather: Input.Optional[String] = None,
    hueFeatherVar: Input.Optional[String] = None,
    hueTolerance: Input.Optional[String] = None,
    hueToleranceVar: Input.Optional[String] = None,
    hueVar: Input.Optional[String] = None,
    lightnessFeather: Input.Optional[String] = None,
    lightnessFeatherVar: Input.Optional[String] = None,
    lightnessTolerance: Input.Optional[String] = None,
    lightnessToleranceVar: Input.Optional[String] = None,
    saturationFeather: Input.Optional[String] = None,
    saturationFeatherVar: Input.Optional[String] = None,
    saturationTolerance: Input.Optional[String] = None,
    saturationToleranceVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyTransformationChromaKeyArgs =
    new GetImagingPolicyImagePolicyTransformationChromaKeyArgs(
      hue = hue.asOptionOutput(isSecret = false),
      hueFeather = hueFeather.asOptionOutput(isSecret = false),
      hueFeatherVar = hueFeatherVar.asOptionOutput(isSecret = false),
      hueTolerance = hueTolerance.asOptionOutput(isSecret = false),
      hueToleranceVar = hueToleranceVar.asOptionOutput(isSecret = false),
      hueVar = hueVar.asOptionOutput(isSecret = false),
      lightnessFeather = lightnessFeather.asOptionOutput(isSecret = false),
      lightnessFeatherVar = lightnessFeatherVar.asOptionOutput(isSecret = false),
      lightnessTolerance = lightnessTolerance.asOptionOutput(isSecret = false),
      lightnessToleranceVar = lightnessToleranceVar.asOptionOutput(isSecret = false),
      saturationFeather = saturationFeather.asOptionOutput(isSecret = false),
      saturationFeatherVar = saturationFeatherVar.asOptionOutput(isSecret = false),
      saturationTolerance = saturationTolerance.asOptionOutput(isSecret = false),
      saturationToleranceVar = saturationToleranceVar.asOptionOutput(isSecret = false)
    )
