package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyTransformationCompositeImageBoxImageArgs private(
  color: Output[Option[String]],
  colorVar: Output[Option[String]],
  height: Output[Option[String]],
  heightVar: Output[Option[String]],
  transformation: Output[Option[besom.api.akamai.inputs.GetImagingPolicyImagePolicyTransformationArgs]],
  width: Output[Option[String]],
  widthVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyTransformationCompositeImageBoxImageArgs:
  def apply(
    color: Input.Optional[String] = None,
    colorVar: Input.Optional[String] = None,
    height: Input.Optional[String] = None,
    heightVar: Input.Optional[String] = None,
    transformation: Input.Optional[besom.api.akamai.inputs.GetImagingPolicyImagePolicyTransformationArgs] = None,
    width: Input.Optional[String] = None,
    widthVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyTransformationCompositeImageBoxImageArgs =
    new GetImagingPolicyImagePolicyTransformationCompositeImageBoxImageArgs(
      color = color.asOptionOutput(isSecret = false),
      colorVar = colorVar.asOptionOutput(isSecret = false),
      height = height.asOptionOutput(isSecret = false),
      heightVar = heightVar.asOptionOutput(isSecret = false),
      transformation = transformation.asOptionOutput(isSecret = false),
      width = width.asOptionOutput(isSecret = false),
      widthVar = widthVar.asOptionOutput(isSecret = false)
    )
