package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyTransformationContrastArgs private(
  brightness: Output[Option[String]],
  brightnessVar: Output[Option[String]],
  contrast: Output[Option[String]],
  contrastVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyTransformationContrastArgs:
  def apply(
    brightness: Input.Optional[String] = None,
    brightnessVar: Input.Optional[String] = None,
    contrast: Input.Optional[String] = None,
    contrastVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyTransformationContrastArgs =
    new GetImagingPolicyImagePolicyTransformationContrastArgs(
      brightness = brightness.asOptionOutput(isSecret = false),
      brightnessVar = brightnessVar.asOptionOutput(isSecret = false),
      contrast = contrast.asOptionOutput(isSecret = false),
      contrastVar = contrastVar.asOptionOutput(isSecret = false)
    )
