package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyTransformationCropArgs private(
  allowExpansion: Output[Option[String]],
  allowExpansionVar: Output[Option[String]],
  gravity: Output[Option[String]],
  gravityVar: Output[Option[String]],
  height: Output[Option[String]],
  heightVar: Output[Option[String]],
  width: Output[Option[String]],
  widthVar: Output[Option[String]],
  xPosition: Output[Option[String]],
  xPositionVar: Output[Option[String]],
  yPosition: Output[Option[String]],
  yPositionVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyTransformationCropArgs:
  def apply(
    allowExpansion: Input.Optional[String] = None,
    allowExpansionVar: Input.Optional[String] = None,
    gravity: Input.Optional[String] = None,
    gravityVar: Input.Optional[String] = None,
    height: Input.Optional[String] = None,
    heightVar: Input.Optional[String] = None,
    width: Input.Optional[String] = None,
    widthVar: Input.Optional[String] = None,
    xPosition: Input.Optional[String] = None,
    xPositionVar: Input.Optional[String] = None,
    yPosition: Input.Optional[String] = None,
    yPositionVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyTransformationCropArgs =
    new GetImagingPolicyImagePolicyTransformationCropArgs(
      allowExpansion = allowExpansion.asOptionOutput(isSecret = false),
      allowExpansionVar = allowExpansionVar.asOptionOutput(isSecret = false),
      gravity = gravity.asOptionOutput(isSecret = false),
      gravityVar = gravityVar.asOptionOutput(isSecret = false),
      height = height.asOptionOutput(isSecret = false),
      heightVar = heightVar.asOptionOutput(isSecret = false),
      width = width.asOptionOutput(isSecret = false),
      widthVar = widthVar.asOptionOutput(isSecret = false),
      xPosition = xPosition.asOptionOutput(isSecret = false),
      xPositionVar = xPositionVar.asOptionOutput(isSecret = false),
      yPosition = yPosition.asOptionOutput(isSecret = false),
      yPositionVar = yPositionVar.asOptionOutput(isSecret = false)
    )
