package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyTransformationFaceCropArgs private(
  algorithm: Output[Option[String]],
  algorithmVar: Output[Option[String]],
  confidence: Output[Option[String]],
  confidenceVar: Output[Option[String]],
  failGravity: Output[Option[String]],
  failGravityVar: Output[Option[String]],
  focus: Output[Option[String]],
  focusVar: Output[Option[String]],
  gravity: Output[Option[String]],
  gravityVar: Output[Option[String]],
  height: Output[Option[String]],
  heightVar: Output[Option[String]],
  padding: Output[Option[String]],
  paddingVar: Output[Option[String]],
  style: Output[Option[String]],
  styleVar: Output[Option[String]],
  width: Output[Option[String]],
  widthVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyTransformationFaceCropArgs:
  def apply(
    algorithm: Input.Optional[String] = None,
    algorithmVar: Input.Optional[String] = None,
    confidence: Input.Optional[String] = None,
    confidenceVar: Input.Optional[String] = None,
    failGravity: Input.Optional[String] = None,
    failGravityVar: Input.Optional[String] = None,
    focus: Input.Optional[String] = None,
    focusVar: Input.Optional[String] = None,
    gravity: Input.Optional[String] = None,
    gravityVar: Input.Optional[String] = None,
    height: Input.Optional[String] = None,
    heightVar: Input.Optional[String] = None,
    padding: Input.Optional[String] = None,
    paddingVar: Input.Optional[String] = None,
    style: Input.Optional[String] = None,
    styleVar: Input.Optional[String] = None,
    width: Input.Optional[String] = None,
    widthVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyTransformationFaceCropArgs =
    new GetImagingPolicyImagePolicyTransformationFaceCropArgs(
      algorithm = algorithm.asOptionOutput(isSecret = false),
      algorithmVar = algorithmVar.asOptionOutput(isSecret = false),
      confidence = confidence.asOptionOutput(isSecret = false),
      confidenceVar = confidenceVar.asOptionOutput(isSecret = false),
      failGravity = failGravity.asOptionOutput(isSecret = false),
      failGravityVar = failGravityVar.asOptionOutput(isSecret = false),
      focus = focus.asOptionOutput(isSecret = false),
      focusVar = focusVar.asOptionOutput(isSecret = false),
      gravity = gravity.asOptionOutput(isSecret = false),
      gravityVar = gravityVar.asOptionOutput(isSecret = false),
      height = height.asOptionOutput(isSecret = false),
      heightVar = heightVar.asOptionOutput(isSecret = false),
      padding = padding.asOptionOutput(isSecret = false),
      paddingVar = paddingVar.asOptionOutput(isSecret = false),
      style = style.asOptionOutput(isSecret = false),
      styleVar = styleVar.asOptionOutput(isSecret = false),
      width = width.asOptionOutput(isSecret = false),
      widthVar = widthVar.asOptionOutput(isSecret = false)
    )
