package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyTransformationFeatureCropArgs private(
  failGravity: Output[Option[String]],
  failGravityVar: Output[Option[String]],
  featureRadius: Output[Option[String]],
  featureRadiusVar: Output[Option[String]],
  gravity: Output[Option[String]],
  gravityVar: Output[Option[String]],
  height: Output[Option[String]],
  heightVar: Output[Option[String]],
  maxFeatures: Output[Option[String]],
  maxFeaturesVar: Output[Option[String]],
  minFeatureQuality: Output[Option[String]],
  minFeatureQualityVar: Output[Option[String]],
  padding: Output[Option[String]],
  paddingVar: Output[Option[String]],
  style: Output[Option[String]],
  styleVar: Output[Option[String]],
  width: Output[Option[String]],
  widthVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyTransformationFeatureCropArgs:
  def apply(
    failGravity: Input.Optional[String] = None,
    failGravityVar: Input.Optional[String] = None,
    featureRadius: Input.Optional[String] = None,
    featureRadiusVar: Input.Optional[String] = None,
    gravity: Input.Optional[String] = None,
    gravityVar: Input.Optional[String] = None,
    height: Input.Optional[String] = None,
    heightVar: Input.Optional[String] = None,
    maxFeatures: Input.Optional[String] = None,
    maxFeaturesVar: Input.Optional[String] = None,
    minFeatureQuality: Input.Optional[String] = None,
    minFeatureQualityVar: Input.Optional[String] = None,
    padding: Input.Optional[String] = None,
    paddingVar: Input.Optional[String] = None,
    style: Input.Optional[String] = None,
    styleVar: Input.Optional[String] = None,
    width: Input.Optional[String] = None,
    widthVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyTransformationFeatureCropArgs =
    new GetImagingPolicyImagePolicyTransformationFeatureCropArgs(
      failGravity = failGravity.asOptionOutput(isSecret = false),
      failGravityVar = failGravityVar.asOptionOutput(isSecret = false),
      featureRadius = featureRadius.asOptionOutput(isSecret = false),
      featureRadiusVar = featureRadiusVar.asOptionOutput(isSecret = false),
      gravity = gravity.asOptionOutput(isSecret = false),
      gravityVar = gravityVar.asOptionOutput(isSecret = false),
      height = height.asOptionOutput(isSecret = false),
      heightVar = heightVar.asOptionOutput(isSecret = false),
      maxFeatures = maxFeatures.asOptionOutput(isSecret = false),
      maxFeaturesVar = maxFeaturesVar.asOptionOutput(isSecret = false),
      minFeatureQuality = minFeatureQuality.asOptionOutput(isSecret = false),
      minFeatureQualityVar = minFeatureQualityVar.asOptionOutput(isSecret = false),
      padding = padding.asOptionOutput(isSecret = false),
      paddingVar = paddingVar.asOptionOutput(isSecret = false),
      style = style.asOptionOutput(isSecret = false),
      styleVar = styleVar.asOptionOutput(isSecret = false),
      width = width.asOptionOutput(isSecret = false),
      widthVar = widthVar.asOptionOutput(isSecret = false)
    )
