package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyTransformationImQueryArgs private(
  allowedTransformations: Output[scala.collection.immutable.List[String]],
  queryVar: Output[String]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyTransformationImQueryArgs:
  def apply(
    allowedTransformations: Input[List[Input[String]]],
    queryVar: Input[String]
  )(using Context): GetImagingPolicyImagePolicyTransformationImQueryArgs =
    new GetImagingPolicyImagePolicyTransformationImQueryArgs(
      allowedTransformations = allowedTransformations.asOutput(isSecret = false),
      queryVar = queryVar.asOutput(isSecret = false)
    )
