package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyTransformationMaxColorArgs private(
  colors: Output[Option[String]],
  colorsVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyTransformationMaxColorArgs:
  def apply(
    colors: Input.Optional[String] = None,
    colorsVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyTransformationMaxColorArgs =
    new GetImagingPolicyImagePolicyTransformationMaxColorArgs(
      colors = colors.asOptionOutput(isSecret = false),
      colorsVar = colorsVar.asOptionOutput(isSecret = false)
    )
