package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyTransformationMirrorArgs private(
  horizontal: Output[Option[String]],
  horizontalVar: Output[Option[String]],
  vertical: Output[Option[String]],
  verticalVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyTransformationMirrorArgs:
  def apply(
    horizontal: Input.Optional[String] = None,
    horizontalVar: Input.Optional[String] = None,
    vertical: Input.Optional[String] = None,
    verticalVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyTransformationMirrorArgs =
    new GetImagingPolicyImagePolicyTransformationMirrorArgs(
      horizontal = horizontal.asOptionOutput(isSecret = false),
      horizontalVar = horizontalVar.asOptionOutput(isSecret = false),
      vertical = vertical.asOptionOutput(isSecret = false),
      verticalVar = verticalVar.asOptionOutput(isSecret = false)
    )
