package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyTransformationOpacityArgs private(
  opacity: Output[Option[String]],
  opacityVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyTransformationOpacityArgs:
  def apply(
    opacity: Input.Optional[String] = None,
    opacityVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyTransformationOpacityArgs =
    new GetImagingPolicyImagePolicyTransformationOpacityArgs(
      opacity = opacity.asOptionOutput(isSecret = false),
      opacityVar = opacityVar.asOptionOutput(isSecret = false)
    )
