package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyTransformationRegionOfInterestCropArgs private(
  gravity: Output[Option[String]],
  gravityVar: Output[Option[String]],
  height: Output[Option[String]],
  heightVar: Output[Option[String]],
  regionOfInterest: Output[besom.api.akamai.inputs.GetImagingPolicyImagePolicyTransformationRegionOfInterestCropRegionOfInterestArgs],
  style: Output[Option[String]],
  styleVar: Output[Option[String]],
  width: Output[Option[String]],
  widthVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyTransformationRegionOfInterestCropArgs:
  def apply(
    gravity: Input.Optional[String] = None,
    gravityVar: Input.Optional[String] = None,
    height: Input.Optional[String] = None,
    heightVar: Input.Optional[String] = None,
    regionOfInterest: Input[besom.api.akamai.inputs.GetImagingPolicyImagePolicyTransformationRegionOfInterestCropRegionOfInterestArgs],
    style: Input.Optional[String] = None,
    styleVar: Input.Optional[String] = None,
    width: Input.Optional[String] = None,
    widthVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyTransformationRegionOfInterestCropArgs =
    new GetImagingPolicyImagePolicyTransformationRegionOfInterestCropArgs(
      gravity = gravity.asOptionOutput(isSecret = false),
      gravityVar = gravityVar.asOptionOutput(isSecret = false),
      height = height.asOptionOutput(isSecret = false),
      heightVar = heightVar.asOptionOutput(isSecret = false),
      regionOfInterest = regionOfInterest.asOutput(isSecret = false),
      style = style.asOptionOutput(isSecret = false),
      styleVar = styleVar.asOptionOutput(isSecret = false),
      width = width.asOptionOutput(isSecret = false),
      widthVar = widthVar.asOptionOutput(isSecret = false)
    )
