package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyTransformationRelativeCropArgs private(
  east: Output[Option[String]],
  eastVar: Output[Option[String]],
  north: Output[Option[String]],
  northVar: Output[Option[String]],
  south: Output[Option[String]],
  southVar: Output[Option[String]],
  west: Output[Option[String]],
  westVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyTransformationRelativeCropArgs:
  def apply(
    east: Input.Optional[String] = None,
    eastVar: Input.Optional[String] = None,
    north: Input.Optional[String] = None,
    northVar: Input.Optional[String] = None,
    south: Input.Optional[String] = None,
    southVar: Input.Optional[String] = None,
    west: Input.Optional[String] = None,
    westVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyTransformationRelativeCropArgs =
    new GetImagingPolicyImagePolicyTransformationRelativeCropArgs(
      east = east.asOptionOutput(isSecret = false),
      eastVar = eastVar.asOptionOutput(isSecret = false),
      north = north.asOptionOutput(isSecret = false),
      northVar = northVar.asOptionOutput(isSecret = false),
      south = south.asOptionOutput(isSecret = false),
      southVar = southVar.asOptionOutput(isSecret = false),
      west = west.asOptionOutput(isSecret = false),
      westVar = westVar.asOptionOutput(isSecret = false)
    )
