package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyTransformationScaleArgs private(
  height: Output[Option[String]],
  heightVar: Output[Option[String]],
  width: Output[Option[String]],
  widthVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyTransformationScaleArgs:
  def apply(
    height: Input.Optional[String] = None,
    heightVar: Input.Optional[String] = None,
    width: Input.Optional[String] = None,
    widthVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyTransformationScaleArgs =
    new GetImagingPolicyImagePolicyTransformationScaleArgs(
      height = height.asOptionOutput(isSecret = false),
      heightVar = heightVar.asOptionOutput(isSecret = false),
      width = width.asOptionOutput(isSecret = false),
      widthVar = widthVar.asOptionOutput(isSecret = false)
    )
