package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyTransformationShearsArgs private(
  xShear: Output[Option[String]],
  xShearVar: Output[Option[String]],
  yShear: Output[Option[String]],
  yShearVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyTransformationShearsArgs:
  def apply(
    xShear: Input.Optional[String] = None,
    xShearVar: Input.Optional[String] = None,
    yShear: Input.Optional[String] = None,
    yShearVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyTransformationShearsArgs =
    new GetImagingPolicyImagePolicyTransformationShearsArgs(
      xShear = xShear.asOptionOutput(isSecret = false),
      xShearVar = xShearVar.asOptionOutput(isSecret = false),
      yShear = yShear.asOptionOutput(isSecret = false),
      yShearVar = yShearVar.asOptionOutput(isSecret = false)
    )
