package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyImagePolicyTransformationTrimArgs private(
  fuzz: Output[Option[String]],
  fuzzVar: Output[Option[String]],
  padding: Output[Option[String]],
  paddingVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyImagePolicyTransformationTrimArgs:
  def apply(
    fuzz: Input.Optional[String] = None,
    fuzzVar: Input.Optional[String] = None,
    padding: Input.Optional[String] = None,
    paddingVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyImagePolicyTransformationTrimArgs =
    new GetImagingPolicyImagePolicyTransformationTrimArgs(
      fuzz = fuzz.asOptionOutput(isSecret = false),
      fuzzVar = fuzzVar.asOptionOutput(isSecret = false),
      padding = padding.asOptionOutput(isSecret = false),
      paddingVar = paddingVar.asOptionOutput(isSecret = false)
    )
