package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyVideoPolicyArgs private(
  breakpoints: Output[Option[besom.api.akamai.inputs.GetImagingPolicyVideoPolicyBreakpointsArgs]],
  hosts: Output[Option[scala.collection.immutable.List[String]]],
  output: Output[Option[besom.api.akamai.inputs.GetImagingPolicyVideoPolicyOutputArgs]],
  rolloutDuration: Output[Option[String]],
  variables: Output[Option[scala.collection.immutable.List[besom.api.akamai.inputs.GetImagingPolicyVideoPolicyVariableArgs]]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyVideoPolicyArgs:
  def apply(
    breakpoints: Input.Optional[besom.api.akamai.inputs.GetImagingPolicyVideoPolicyBreakpointsArgs] = None,
    hosts: Input.Optional[List[Input[String]]] = None,
    output: Input.Optional[besom.api.akamai.inputs.GetImagingPolicyVideoPolicyOutputArgs] = None,
    rolloutDuration: Input.Optional[String] = None,
    variables: Input.Optional[List[Input[besom.api.akamai.inputs.GetImagingPolicyVideoPolicyVariableArgs]]] = None
  )(using Context): GetImagingPolicyVideoPolicyArgs =
    new GetImagingPolicyVideoPolicyArgs(
      breakpoints = breakpoints.asOptionOutput(isSecret = false),
      hosts = hosts.asOptionOutput(isSecret = false),
      output = output.asOptionOutput(isSecret = false),
      rolloutDuration = rolloutDuration.asOptionOutput(isSecret = false),
      variables = variables.asOptionOutput(isSecret = false)
    )
