package besom.api.akamai.inputs 

import besom.types.Output
import besom.types.Context
import besom.types.Input
import besom.types.Encoder
import besom.types.ArgsEncoder

final case class GetImagingPolicyVideoPolicyOutputArgs private(
  perceptualQuality: Output[Option[String]],
  perceptualQualityVar: Output[Option[String]],
  placeholderVideoUrl: Output[Option[String]],
  placeholderVideoUrlVar: Output[Option[String]],
  videoAdaptiveQuality: Output[Option[String]],
  videoAdaptiveQualityVar: Output[Option[String]]
) derives Encoder, ArgsEncoder

object GetImagingPolicyVideoPolicyOutputArgs:
  def apply(
    perceptualQuality: Input.Optional[String] = None,
    perceptualQualityVar: Input.Optional[String] = None,
    placeholderVideoUrl: Input.Optional[String] = None,
    placeholderVideoUrlVar: Input.Optional[String] = None,
    videoAdaptiveQuality: Input.Optional[String] = None,
    videoAdaptiveQualityVar: Input.Optional[String] = None
  )(using Context): GetImagingPolicyVideoPolicyOutputArgs =
    new GetImagingPolicyVideoPolicyOutputArgs(
      perceptualQuality = perceptualQuality.asOptionOutput(isSecret = false),
      perceptualQualityVar = perceptualQualityVar.asOptionOutput(isSecret = false),
      placeholderVideoUrl = placeholderVideoUrl.asOptionOutput(isSecret = false),
      placeholderVideoUrlVar = placeholderVideoUrlVar.asOptionOutput(isSecret = false),
      videoAdaptiveQuality = videoAdaptiveQuality.asOptionOutput(isSecret = false),
      videoAdaptiveQualityVar = videoAdaptiveQualityVar.asOptionOutput(isSecret = false)
    )
